/*= Metrix OX8027 Oscilloscope Include File =================================*/

/*===========================================================================*/
/*  Please do not use global variables or arrays in the include file of      */
/*  instrument drivers that will be submitted for inclusion into the         */
/*  LabWindows Instrument Driver Library.                                    */
/*===========================================================================*/
     
#ifndef __mxOX802x_HEADER
#define __mxOX802x_HEADER

#include <vpptype.h>

#if defined(__cplusplus) || defined(__cplusplus__)
extern "C" {
#endif


/*****************************************************************************/
/*= Instrument Driver Specific Error/Warning Codes ==========================*/
/*****************************************************************************/
#define VI_ERROR_INSTR_FILE_OPEN                (_VI_ERROR+0x3FFC0800L)
#define VI_ERROR_INSTR_FILE_WRITE               (_VI_ERROR+0x3FFC0801L)
#define VI_ERROR_INSTR_INTERPRETING_RESPONSE    (_VI_ERROR+0x3FFC0803L)
#define VI_ERROR_INSTR_PARAMETER9               (_VI_ERROR+0x3FFC0809L)
#define VI_ERROR_INSTR_PARAMETER10              (_VI_ERROR+0x3FFC080AL)
#define VI_ERROR_INSTR_PARAMETER11              (_VI_ERROR+0x3FFC080BL)
#define VI_ERROR_INSTR_PARAMETER12              (_VI_ERROR+0x3FFC080CL)
#define VI_ERROR_INSTR_PARAMETER13              (_VI_ERROR+0x3FFC080DL)
#define VI_ERROR_INSTR_PARAMETER14              (_VI_ERROR+0x3FFC080EL)
#define VI_ERROR_INSTR_PARAMETER15              (_VI_ERROR+0x3FFC080FL)

/*****************************************************************************/
/*= Define Instrument Specific Error/Warning Codes Here =====================*/
/*****************************************************************************/
#define VI_WARNING_INSTR_OFFSET                           (0x3FFC0900L)
#define VI_ERROR_INSTR_OFFSET                   (_VI_ERROR+0x3FFC0900L)

/*****************************************************************************/
/*= Define Instrument Specific Error Codes Here =============================*/
/*****************************************************************************/
#define MXOX802X_ERROR_INSTRUMENT_ERROR       (VI_ERROR_INSTR_OFFSET+0x00L)
#define MXOX802X_ERROR_INSTR_TRACE_NOT_AVAIL  (VI_ERROR_INSTR_OFFSET+0x01L)
#define MXOX802X_ERROR_INSTR_MEAS_FAILED      (VI_ERROR_INSTR_OFFSET+0x02L)
#define MXOX802X_ERROR_INSTR_SET_EXPANSION    (VI_ERROR_INSTR_OFFSET+0x03L)
#define MXOX802X_ERROR_INSTR_READ_TRACE       (VI_ERROR_INSTR_OFFSET+0x04L)
#define MXOX802X_ERROR_INSTR_SAVE_TRACE       (VI_ERROR_INSTR_OFFSET+0x05L)

/*****************************************************************************/
/*= GLOBAL USER-CALLABLE FUNCTION DECLARATIONS (Exportable Functions) =======*/
/*****************************************************************************/
ViStatus _VI_FUNC mxOX802x_init (ViRsrc resourceName, ViBoolean IDQuery,
                    ViBoolean resetDevice, ViPSession instrumentHandle);
ViStatus _VI_FUNC mxOX802x_example (ViSession instrumentHandle, ViInt32 timebase,
                    ViInt32 voltageRange, ViInt32 coupling,
                    ViReal64 _VI_FAR data[], ViPReal64 deltaT,
                    ViPInt32 numberofSamples);
ViStatus _VI_FUNC mxOX802x_readWriteSetup (ViSession instrumentHandle,
                    ViBoolean mode,
                    ViChar _VI_FAR instrumentSetup[]);
ViStatus _VI_FUNC mxOX802x_autoScale (ViSession instrumentHandle);
ViStatus _VI_FUNC mxOX802x_confAcq (ViSession instrumentHandle, ViInt32 mode,
                    ViBoolean glitchDetect);
ViStatus _VI_FUNC mxOX802x_confInp (ViSession instrumentHandle, ViInt32 channel,
                    ViInt32 voltageRange, ViInt32 coupling,
                    ViBoolean invertCH2);
ViStatus _VI_FUNC mxOX802x_confHoriz (ViSession instrumentHandle, ViInt32 timebase,
                    ViInt32 expansion);
ViStatus _VI_FUNC mxOX802x_confSaveTrace (ViSession instrumentHandle, ViInt32 trace,
                    ViBoolean readOnly);
ViStatus _VI_FUNC mxOX802x_confDisp (ViSession instrumentHandle,
                    ViInt32 displayMode, ViInt32 feedTraces,
                    ViInt32 interpolation, ViInt32 windowOrigin);
ViStatus _VI_FUNC mxOX802x_confTrig (ViSession instrumentHandle, ViInt32 source,
                    ViInt32 mode, ViInt32 coupling,
                    ViBoolean slope, ViInt32 pretriggerDelay);
ViStatus _VI_FUNC mxOX802x_trigger (ViSession instrumentHandle, ViInt32 mode,
                    ViBoolean wait);
ViStatus _VI_FUNC mxOX802x_measure (ViSession instrumentHandle, ViInt32 function,
                    ViInt32 source, ViPReal64 output);
ViStatus _VI_FUNC mxOX802x_readTrace (ViSession instrumentHandle, ViInt32 trace,
                    ViReal64 _VI_FAR traceData[],
                    ViPInt32 numberOfSamples, ViPReal64 t0,
                    ViPReal64 dt);
ViStatus _VI_FUNC mxOX802x_writeInstrData (ViSession instrumentHandle,
                    ViString writeBuffer);
ViStatus _VI_FUNC mxOX802x_readInstrData (ViSession instrumentHandle,
                    ViInt16 numberBytesToRead,
                    ViChar _VI_FAR readBuffer[],
                    ViPInt32 numBytesRead);
ViStatus _VI_FUNC mxOX802x_reset (ViSession instrumentHandle);
ViStatus _VI_FUNC mxOX802x_selfTest (ViSession instrumentHandle,
                    ViPInt16 selfTestResult,
                    ViChar _VI_FAR selfTestMessage[]);
ViStatus _VI_FUNC mxOX802x_errorQuery (ViSession instrumentHandle,
                    ViPInt32 errorCode,
                    ViChar _VI_FAR errorMessage[]);
ViStatus _VI_FUNC mxOX802x_errorMessage (ViSession instrumentHandle,
                    ViStatus statusCode,
                    ViChar _VI_FAR message[]);
ViStatus _VI_FUNC mxOX802x_revisionQuery (ViSession instrumentHandle,
                    ViChar _VI_FAR instrumentDriverRevision[],
                    ViChar _VI_FAR firmwareRevision[]);
ViStatus _VI_FUNC mxOX802x_frontPanLock (ViSession instrumentHandle, ViBoolean mode);
ViStatus _VI_FUNC mxOX802x_close (ViSession instrumentHandle);

#if defined(__cplusplus) || defined(__cplusplus__)
}
#endif

/*****************************************************************************/
/*=== END INCLUDE FILE ======================================================*/
/*****************************************************************************/

#endif
