s        	                                           mxOX802x    Metrix OX8020/27 Oscilloscope (VISA I/O)        ViInt16     ViInt32    ViReal64      ViRsrc     	 	ViBoolean     	 	ViSession      ViStatus       ViChar[]      ViChar      ViString     	  ViInt16[]     	  ViInt32[]     
  	ViReal64[]      	 
ViBoolean[]  c    This instrument module provides programming support for the Metrix OX8020/27 Oscilloscope.  The module is divided into the following functions:

Functions/Classes:

(1) Initialize:
This function initializes the instrument and sets it to a default configuration.

(2) Application Functions: (Class)
This class contains high-level, test and measurement routines.  These examples call other instrument driver functions to configure, start, and read from the instrument.

(3) Configuration Functions: (Class)
This class of functions configures the instrument by setting acquisition and system configuration parameters.

(4) Action/Status Functions: (Class)
This class of functions begins or terminates an acquisition. It also provides functions which allow the user to determine the current status of the instrument.

(5) Data Functions: (Class)
This class of functions transfers data to or from the instrument.

(6) Utility Functions: (Class)
This class of functions provides lower level functions to communicate with the instrument, and change instrument parameters.

(7) Close:
This function takes the instrument offline.
         This class contains high-level, test and measurement routines.  These examples call other instrument driver functions to configure, start, and read from the instrument.

Functions:

(1) Example:
This function works as a simple single channel digitizer.    "    This class of functions configures the instrument by setting acquisition and system configuration parameters.

Functions:

(1) Read/Write Setup:
This function reads/writes the instrument setup data from/to the instrument.

(2) Autoscale:
This function initiates the autoscaling operation.

(3) Config Acquisition:
This function configures the acquisition modes of the instrument.

(4) Config Input:
This function configures the selected input channel of the instrument.

(5) Config Horizontal:
This function configures the horizontal settings of the instrument.

(6) Config Save Trace:
This function controls the trace memories.

(7) Config Display:
This function performs the instrument's display configuration.

(8) Config Trigger:
This function configures the triggering system of the instrument.
         This class of functions begins or terminates an acquisition. It also provides functions which allow the user to determine the current status of the instrument.

Functions:

(1) Trigger:
This function controls the triggering system of the instrument.
        This class of functions transfers data to or from the instrument.

Functions:

(1) Measure:
This function forces the instrument to perform selected measurement and returns the result.

(2) Read Trace:
This function reads the trace data from the instrument.
        This class of functions provides lower level functions to communicate with the instrument, and change instrument parameters.

Functions:

(1) Write To Instrument:
This function writes commands and queries to the instrument to modify parameters and query device settings.

(2) Read Instrument Data:
This function reads data from instrument buffer and returns it to the specified variable in memory.

(3) Reset:
This function resets the instrument to its default state.

(4) Self-Test:
This function runs the instrument self test and returns the test code.

(5) Error Query:
This function reads an error code from the instrument error queue.

(6) Error Message:
This function takes the Status Code and returns it as a user readable string.
 
(7) Revision Query:
This function returns the revision numbers of the instrument driver and instrument firmware.

(8) Front Panel Lockout:
This function controls the instrument's front panel lockout state.
    2    This function performs the following initialization actions:

- Opens a session to the Default Resource Manager resource and a session to the specified device using the interface and address specified in the Resource Name control.

- Performs an identification query on the Instrument.

- Resets the instrument to a known state.

- Sends initialization commands to the instrument that set any necessary programmatic variables such as Headers Off, Short Command form, and Data Transfer Binary to the state necessary for the operation of the instrument driver.

- Returns an Instrument Handle which is used to differentiate between different sessions of this instrument driver.

- Each time this function is invoked a Unique Session is opened.  It is possible to have more than one session open for the same resource.
        This control specifies the interface and address of the device that is to be initialized (Instrument Descriptor). The exact grammar to be used in this control is shown in the note below. 

Default Value:  "GPIB::1"

Notes:

(1) Based on the Instrument Descriptor, this operation establishes a communication session with a device.  The grammar for the Instrument Descriptor is shown below.  Optional parameters are shown in square brackets ([]).

Interface   Grammar
------------------------------------------------------
GPIB        GPIB[board]::primary address[::secondary address]
            [::INSTR]
Serial      ASRLserialport[::INSTR]
            
The GPIB keyword is used with GPIB instruments.
The ASRL keyword is used with serial instruments.

The default value for optional parameters are shown below.

Optional Parameter          Default Value
-----------------------------------------
board                       0
secondary address           none - 31
        This control specifies if an ID Query is sent to the instrument during the initialization procedure.

Valid Range:
VI_OFF (0) - Skip Query
VI_ON  (1) - Do Query (Default Value)

Notes:
   
(1) Under normal circumstances the ID Query ensures that the instrument initialized is the type supported by this driver. However circumstances may arise where it is undesirable to send an ID Query to the instrument.  In those cases; set this control to "Skip Query" and this function will initialize the selected interface, without doing an ID Query.
    C    This control specifies if the instrument is to be reset to its power-on settings during the initialization procedure.

Valid Range:
VI_OFF (0) - Don't Reset
VI_ON  (1) - Reset Device (Default Value)

Notes:

(1) If you do not want the instrument reset. Set this control to "Don't Reset" while initializing the instrument.    7    This control returns an Instrument Handle that is used in all subsequent function calls to differentiate between different sessions of this instrument driver.

Notes:

(1) Each time this function is invoked a Unique Session is opened.  It is possible to have more than one session open for the same resource.
        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.

BFFC0011  Instrument returned invalid response to ID Query

BFFC0803  Error Scanning Response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
    ; =         Resource Name                     
 :        ID Query                          1 =        Reset Device                      |     }    Instrument Handle                       Status                             F                                                                                      t                                           t                                           t                                           t                                            
"GPIB::1"  ! Do Query VI_ON Skip Query VI_OFF  & Reset Device VI_ON Don't Reset VI_OFF    	           	           GCopyright 1996 National Instruments Corporation.  All Rights Reserved.    In Serial mode : Speed = 9800    Parity = none    Data = 8 bits    Protocol = RTS/CTS (hard)    
Stop bit = 1       This function is an example of this driver's functions use. It works as a simple single channel digitizer.
     The instrument is set to the single shot digital mode in dual channel configuration. User can change the timebase (Timebase), the input voltage range (Voltage Range) and the input coupling (Coupling).
A trigger is then sent to the instrument. The Trigger function waits until the acquisition is completed. Channel S1 is read out from the instrument after the acquisition completes.
    y    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

BFFC0002  Parameter 2 (Timebase) out of range.
BFFC0003  Parameter 3 (Voltage Range) out of range.
BFFC0004  Parameter 4 (Coupling) out of range.

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0803  Error Scanning Response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None
    z    This control sets the timebase of the oscilloscope.

Valid Values:
0 - 0.1 us/div
1 - 0.2 us/div
2 - 0.5 us/div
3 - 1 us/div
4 - 2 us/div
5 - 5 us/div
6 - 10 us/div
7 - 20 us/div
8 - 50 us/div  (Default Value)
9 - 100 us/div
10 - 200 us/div
11 - 500 us/div
12 - 1 ms/div
13 - 2 ms/div
14 - 5 ms/div
15 - 10 ms/div
16 - 20 ms/div
17 - 50 ms/div
18 - 100 ms/div
19 - 200 ms/div
    =    This control sets the input range of the selected channel in units of volts per division.

Valid Values:
0 - 1 mV/div
1 - 2 mV/div
2 - 5 mV/div
3 - 10 mV/div
4 - 20 mV/div
5 - 50 mV/div
6 - 100 mV/div
7 - 200 mV/div
8 - 500 mV/div
9 - 1 V/div
10 - 2 V/div
11 - 5 V/div
12 - 10 V/div
13 -  20 V/div  (Default Value)
     y    This control selects the input coupling of the selected channel.

Valid Values:
0 - AC  (Default Value)
1 - DC
2 - GND
         Returns an array of the trace S1 data in units of volts.

Notes:

(1) The array must contain at least 1024 elements ViReal64[1024].
         This control returns number of samples acquired by the instrument. If the function executes successfully, value returned by this control is equal to a number of valid samples contained within control data.
     f    This control returns the time difference between two samples of the trace data in units of seconds.
    %      Status                            *4         Instrument Handle                 * A 0       Timebase                          ,V  0       Voltage Range                     -  0       Coupling                          . A         Data                              . A        Number of Samples                 /          Delta T                            	                         0.1 us/div 0 0.2 us/div 1 0.5 us/div 2 1 us/div 3 2 us/div 4 5 us/div 5 10 us/div 6 20 us/div 7 50 us/div 8 100 us/div 9 200 us/div 10 500 us/div 11 1 ms/div 12 2 ms/div 13 5 ms/div 14 10 ms/div 15 20 ms/div 16 50 ms/div 17 100 ms/div 18 200 ms/div 19        
      1 mV/div 0 2 mV/div 1 5 mV/div 2 10 mV/div 3 20 mV/div 4 50 mV/div 5 100 mV/div 6 200 mV/div 7 500 mV/div 8 1 V/div 9 2 V/div 10 5 V/div 11 10 V/div 12 20 V/div 13               AC 0 DC 1 GND 2    	            	            	               This function reads/writes the instrument setup data from/to the instrument. The setup data being read from the instrument always contains current configuration.
        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Mode) out of range.

BFFC0803  Error Scanning Response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None
         This control specifies whether to read or write the instrument setup string.

Valid Values:
VI_OFF (0) - Write
VI_ON  (1) - Read  (Default Value)
        This control contains the binary setup data. When reading the setup data, the setup data is output via this control. To write the setup data, use setup strings read from the instrument before.
The setup string is 57 characters long. If the setup data contained in the string are invalid on writes an error is generated.

Default Value: ""

Notes:

(1) The array must contain at least 58 elements ViChar[58].
    4U      Status                            8o         Instrument Handle                 9 M h        Mode                              9 M8        Instrument Setup                   	              Read VI_ON Write VI_OFF    ""       This function initiates the autoscaling operation.

Notes:

(1) In the analog mode, signals are displayed as soon as the autoscale is complete.

(2) In the digital mode, there are two possibilities depending on the state of acquisition:
Idle (continuous acquisition is off): only the current settings and the channel selection are updated on the screen.
Active (continuous acquisition is on): acquisition is automatically reinitiated after the end of the autoscale.
        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0803  Error Scanning Response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None
    >.      Status                            B         Instrument Handle                  	                   This function configures the acquisition modes of the instrument. The following settings are accessible:

- acquisition mode, incl. envelope mode
- glitch detect function    F    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Mode) out of range.
BFFC0003  Parameter 3 (Glitch Detect) out of range.

BFFC0803  Error Scanning Response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None
        This control specifies the acquisition mode of the oscilloscope.

Valid Values:
0 - Refresh  (Default Value)
1 - Roll
2 - Single
3 - Envelope
4 - Analog

Notes:

(1) In the Refresh Mode the instrument works like the traditional analog oscilloscope.

(2) The Roll Mode is available only if the timebase is greater than 200 ms/div. An error is generated for smaller timebases.

(3) In the Single Mode the instrument acquires a single trace and stops the acquisition.

(4) The Envelope Mode is available only if the timebase is 200 ms/div or less. This mode is similar to the refresh mode. The difference is that the previously acquired signals persist on instrument's display. Trace data read over the GPIB or serial interface contain the last acquired signal.
         This control turns on or off the glitch detect function of the instrument (OX8027 only).

Valid Values:
VI_OFF (0) - Off  (Default Value)
VI_ON  (1) - On

Notes:

(1) The glitch detect feature is available only when in the digital mode.
    C      Status                            H8         Instrument Handle                 H F        Mode                              K Fk        Glitch Detect                      	                          .Refresh 0 Roll 1 Single 2 Envelope 3 Analog 4    On VI_ON Off VI_OFF        This function configures the selected input channel of the instrument.
The following settings are accessible:

- channel
- coupling
- range
- second channel inversion switch
        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Channel) out of range.
BFFC0003  Parameter 3 (Voltage Range) out of range.
BFFC0004  Parameter 4 (Coupling) out of range.
BFFC0005  Parameter 5 (Invert CH2) out of range.

BFFC0803  Error Scanning Response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None
     b    This control selects the channel to configure.

Valid Values: 
1 - CH1  (Default Value)
2 - CH2
    ?    This control sets the input range of the selected channel in units of volts per division.

Valid Values:
0 - 1 mV/div
1 - 2 mV/div
2 - 5 mV/div
3 - 10 mV/div
4 - 20 mV/div
5 - 50 mV/div
6 - 100 mV/div  (Default Value)
7 - 200 mV/div
8 - 500 mV/div
9 - 1 V/div
10 - 2 V/div
11 - 5 V/div
12 - 10 V/div
13 -  20 V/div  
     y    This control selects the input coupling of the selected channel.

Valid Values:
0 - AC  (Default Value)
1 - DC
2 - GND
         This control specifies whether to invert the second channel or not. It has an effect only if the control channel is set to 2.

Valid Value:
VI_OFF (0) - No  (Default Value)
VI_ON  (1) - Yes
    N      Status                            Sq         Instrument Handle                 T E        Channel                           T{ E/       Voltage Range                     U  r  `    Coupling                          VC ]        Invert CH2                         	              1 1 2 2              1 mV/div 0 2 mV/div 1 5 mV/div 2 10 mV/div 3 20 mV/div 4 50 mV/div 5 100 mV/div 6 200 mV/div 7 500 mV/div 8 1 V/div 9 2 V/div 10 5 V/div 11 10 V/div 12 20 V/div 13               AC 0 DC 1 GND 2    Yes VI_ON No VI_OFF        This function configures the horizontal settings of the instrument.
The following settings are available:

- range (the actual timebase)
- horizontal expansion
        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Timebase) out of range.
BFFC0003  Parameter 3 (Expansion) out of range.

BFFC0803  Error Scanning Response

BFFC0900  Instrument specific error.
BFFC0903  Error setting expansion when acquisition is running.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None
        This control sets the timebase of the oscilloscope. See the note below for more information.

Valid Values:
0 - 0.1 us/div
1 - 0.2 us/div
2 - 0.5 us/div
3 - 1 us/div
4 - 2 us/div
5 - 5 us/div
6 - 10 us/div
7 - 20 us/div
8 - 50 us/div  (Default Value)
9 - 100 us/div
10 - 200 us/div
11 - 500 us/div
12 - 1 ms/div
13 - 2 ms/div
14 - 5 ms/div
15 - 10 ms/div
16 - 20 ms/div
17 - 50 ms/div
18 - 100 ms/div
19 - 200 ms/div
20 - 500 ms/div
21 - 1 s/div
22 - 2 s/div
23 - 5 s/div
24 - 10 s/div
25 - 20 s/div
26 - 50 s/div
27 - 100 s/div
28 - 200 s/div

Notes:
(1) In the analog mode the timebase is limited to the range between 0.5 us and 200ms. Attempt to set value outside of the limits generates an error.
        This control sets the horizontal expansion factor in digital as well as in the analog mode.

Valid Values:  See the table below.

Default Value: 10 - No Change

Setting      Factor               Points Displayed 
====================================================
0            x 0.1                 8000 (OX8027 only)
1            x 0.2 or x 0.25       5000 or 4000        
2            x 0.4 or x 0.5        2500 or 2000             
3            x 1.0                 1000              
4            x 2.0 or x 2.5         500 or 400            
5            x 4   or x 5           250 or 200              
6            x 10                   100
7            x 20  or x 25           50 or 40      
8            x 1  (analog mode)
9            x 10 (analog mode)
10           No Change

Notes:
(1) Use setting No Change (10) if you want to change the timebase on the fly (when acquisition is running). Failing to do so will generate an error.
    Y      Status                            ^         Instrument Handle                 _# W Z       Timebase                          a W=      Expansion                          	                        i0.1 us/div 0 0.2 us/div 1 0.5 us/div 2 1 us/div 3 2 us/div 4 5 us/div 5 10 us/div 6 20 us/div 7 50 us/div 8 100 us/div 9 200 us/div 10 500 us/div 11 1 ms/div 12 2 ms/div 13 5 ms/div 14 10 ms/div 15 20 ms/div 16 50 ms/div 17 100 ms/div 18 200 ms/div 19 500 ms/div 20 1 s/div 21 2 s/div 22 5 s/div 23 10 s/div 24 20 s/div 25 50 s/div 26 100 s/div 27 200 s/div 28        
      0.1 x      (OX8027 only) 0 0.2 x  or  0.25 x 1 0.4 x  or  0.5 x 2 1.0 x 3 2.0 x  or 2.5 x 4 4.0 x  or  5.0 x 5 10.0 x 6 20 x  or  25 x 7 1 x  In Analog Mode 8 10 x  In Analog Mode 9 No Change 10   Z    This function controls the access to the trace memories (CH1A, CH1B, CH2A, CH2B). It has an effect only when in the digital mode.

Notes:
 
(1) This function will perform properly only if the acquisition is not running. If this function is called when acquisition is running, an error is generated. Stop the acquisition using function Trigger.
        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Trace) out of range.
BFFC0003  Parameter 3 (Read Only) out of range.

BFFC0803  Error Scanning Response

BFFC0900  Instrument specific error.
BFFC0905  Attempt to save trace when the acquisition is running.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None
         This control selects the memory to be write-protected or not.

Valid Values:
0 - CH1A  (Default Value)
1 - CH1B  (OX8027 only)
2 - CH2A
3 - CH2B  (OX8027 only)

Notes:

(1) There are two storage memories (A and B) for each channel (CH1 and CH2).
        This control specifies if the selected memory (CH1A, CH1B, CH2A, CH2B) is write-protected (Read only on) or not (Read only off).

Valid Values:
VI_OFF (0) - Off  (Default Value)
VI_ON  (1) - On  

Notes:

(1) To save the trace to the memory the acquisition must be in the idle mode (continuous acquisition is off). Attempt to save trace in the continuous acquisition mode generates an error.
    j7      Status                            n         Instrument Handle                 oc W Z      Trace                             pc Xi        Read Only                          	                          :CH1A 0 CH1B  (OX8027 only) 1 CH2A 2 CH2B  (OX8027 only) 3    On VI_ON Off VI_OFF       This function performs the instrument's display configuration. The following settings are accessible via this function:

- display mode
- filtering (digital interpolation)
- trace feed (what traces are going to be displayed on the screen)
- screen window origin        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Display Mode) out of range.
BFFC0003  Parameter 3 (Feed Traces) out of range.
BFFC0004  Parameter 4 (Interpolation) out of range.
BFFC0005  Parameter 5 (Window Origin) out of range.

BFFC0803  Error Scanning Response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None
    d    This control selects the trace's display mode of the instrument.

Valid Values:
0 - CH1
1 - ALT
2 - CHOP  (Default Value)
3 - CH2
4 - XY
5 - CH1+CH2
6 - CH1*CH2

Notes:

(1) The options 0 and 3 select only single trace (CH1 or CH2) to be displayed.

(2) The multiplication mode (6) is allowed only when the instrument is in the digital acquisition mode.
        This control selects traces to be fed to the instrument's display (OX8027 only). See the table below to get more info.

Valid Values:
0 - A Channel(s)  (Default Value)
1 - B Channel(s)
2 - A and B Channels
3 - B and A Channels

        
                D I S P L A Y   M O D E S

Setting    CH1              CH2        Dual Chan Disp. Modes
=============================================================
0          CH1A             CH2A             CH1A   CH2A
1          CH1B             CH2B             CH1B   CH2B
2       CH1A CH1B        CH2A CH2B           CH1A   CH2B
3     not available    not available         CH1B   CH2A

Notes:

(1) This control has no effect on display in the analog mode.
        This control specifies interpolation method of the sampled traces.

Valid Values:
0 - None  (Default Value)
1 - Linear
2 - Sinusoidal

Notes:

(1) The interpolation can be applied only to the sampled traces, i.e. the instrument must be in the digital mode.
        This control specifies the screen window origin in the scope's digital mode. It has no effect in the analog mode.

Valid Range: 0 to 8000

Default Value: 0

Notes:

(1) Zero is the left end of the signal sweep, 8000 is the right end. There are 8192 points per signal sweep.
    tH      Status                            y         Instrument Handle                 y K .       Display Mode                      { K        Feed Traces                       } K       Interpolation                     ~  .       Window Origin                      	                         2CH1 0 ALT 1 CHOP 2 CH2 3 XY 4 CH1+CH2 5 CH1*CH2 6               DA Channel(s) 0 B Channel(s) 1 A and B Channels 2 B and A Channels 3               None 0 Linear 1 Sinusoidal 2    0        This function configures the triggering system of the instrument. The following settings can be configured with this function:

- trigger source
- trigger mode
- coupling
- trigger slope
- pretrigger or delay
        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Source) out of range.
BFFC0003  Parameter 3 (Mode) out of range.
BFFC0004  Parameter 4 (Coupling) out of range.
BFFC0005  Parameter 5 (Slope) out of range.
BFFC0006  Parameter 6 (Pretrigger/Delay) out of range.

BFFC0803  Error Scanning Response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None
        This control selects the trigger source. See the notes below to get more information.

Valid Values:
0 - Channel 1  (Default Value)
1 - Channel 2
2 - Display Dependent
3 - Line
4 - External

Notes:

(0) The syncronization source is selected in the following manner:

Channel 1:  Synchronized on channel 1.

Channel 2:  Synchronized on channel 2.

Display Dependent:  The trigger source is defined by the display mode, see the table below for more information:

  display mode            trigger source
======================================================
    CH1                         CH1
    ALT               channel 1 synchronized with CH1
                      channel 2 synchronized with CH2
    CHOP                        CH1
    ADD (CH1+CH2)               CH1    
    CH2                         CH2
   -CH2                         CH2


Line:      Synchronized on the mains power sypply.

External:  Synchronized on external source via the EXT connector
           on the front panel of the instrument.
        This control selects the triggering mode of the instrument.

Valid Values:
0 - Normal
1 - Peak To Peak
2 - Auto  (Default Value)

Notes:

(0)  The trigger level is set manually via the knob labeled LEVEL on the front panel of the instrument. The range is approx. -20div to 20 div.

(1)  The Peak To Peak trigger sets it's trigger level maximum and minimum to the max-peak and min-peak values of the source signal. The trigger level can be adjusted as if it was in the normal mode.

(2)  In the Auto mode the trigger events are generated regardless of the triggering conditions, the measured signal is not synchronized with the timebase.
    u    This control specifies the trigger signal coupling. See the note below for more information.

Valid Values:
0 - DC  (Default Value)
1 - AC
2 - LF
3 - HF
4 - TVH
5 - TVV

Notes:

(0)  DC coupling (0 to 40 MHz)

(1)  AC coupling (10 Hz to 40 MHz)

(2)  Rejects frequencies below 10 kHz from the source signal (facilitates observation of signals with DC component).

(3)  Rejects frequencies above 10 kHz from the source signal (facilitates observation of signals with high frequency noise).

(4)  Triggers on video signal line sync pulses (recommended timebase: 0.5 us to 20 us).

(5)  Triggers on video signal field sync pulse.
         This control specifies the slope of the trigger source.

Valid Values:
VI_OFF (0) - Negative  (Default Value)
VI_ON  (1) - Positive  
        This control specifies either the pretrigger or the delay state of the triggering system of the instrument. See the notes below for more information.

Valid Values:
8 - 8192 points  (OX8027 only)
7 - 7168 points  (OX8027 only)
6 - 6144 points  (OX8027 only)
5 - 5120 points  (OX8027 only)
4 - 4096 points
3 - 3072 points
2 - 2048 points
1 - 1024 points
0 - 0  (Default Value)
-1 - manual delay

Notes:

(1) Settings 1 to 8 specify the pretrigger value in points (has no effect in the analog mode).

(2) Setting 8 turns off the pretrigger AND delay.

(3) Setting 9 turns the delay status on, i.e. the delay value can be changed using DELAY knob on the front panel of the instrument.
          Status                                     Instrument Handle                 f K .       Source                            i K        Mode                               K       Coupling                          m          Slope                                    Pretrigger/Delay                   	                          >Channel 1 0 Channel 2 1 Display Dependent 2 Line 3 External 4              Normal 0 Peak To Peak 1 Auto 2                DC 0 AC 1 LF 2 HF 3 TVH 4 TVV 5   Positive VI_ON Negative VI_OFF           
   8192  (OX8027 only) 8 7168  (OX8027 only) 7 6144  (OX8027 only) 6 5120  (OX8027 only) 5 4096 4 3072 3 2048 2 1024 1 0 0 Manual Delay -1    t    This function controls the triggering system of the instrument. Triggering the oscilloscope runs the acquisition.
    >    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Mode) out of range.
BFFC0003  Parameter 3 (Wait?) out of range.

BFFC0803  Error Scanning Response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None
    	    This control controls the acquisition system of the instrument.

Valid Values:
0 - Continuous  (Default Value)
1 - Single Shot
2 - Abort

Notes:

(1) In the analog mode the interface controlled triggering has no effect.

(2) In the continuous mode the instrument uses triggers generated by the trigger source as specified in function Config Trigger. The continuous acquisition can be aborted by setting abort to this control. To resume the aborted acquisition use either continuous or single shot.

(3) When in the roll acquisition mode the option continuous changes the acquisition mode to refresh. The single shot trigger enables to start the roll mode acquisition, but it does not start until the triggering conditions as specified in the function Config Trigger are met. The acquisition can be aborted by setting abort to this control. To resume the aborted acquisition use the option single shot.

(4) When in the single acquisition mode the option continuous changes the acquisition mode to refresh. The single shot trigger enables to start the roll mode acquisition, but it does not start until the triggering conditions as specified in the function Config Trigger are met. The acquisition can be aborted by setting abort to this control. To resume the aborted acquisition use the option single shot.

(5) If you want to use the instrument as a computer triggered digitizer, set the control mode in the function Config Trigger to auto and use the single acquisition mode. As a trigger use function Trigger with mode set to single shot.
        This control selects whether to wait until a single shot operation (in single or roll mode) is completed.

Valid Values:
VI_OFF (0) - No  (Default Value)
VI_ON  (1) - Yes

Notes:

(1) This control is valid only if the single shot trigger mode is selected.
          Status                            Y         Instrument Handle                  O        Mode                              
 Nj        Wait?                              	                          #Continuous 0 Single Shot 1 Abort 2    Yes VI_ON No VI_OFF    ^    This function forces the instrument to perform selected measurement and returns the result.
    u    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Function) out of range.
BFFC0003  Parameter 3 (Source) out of range.

BFFC0803  Error Scanning Response

BFFC0900  Instrument specific error.
BFFC0902  Measurement failed (See User's manual).

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None
        This control specifies the measurement function.

Valid Values:
0 - Root Mean Square Voltage [V] (Default Value)
1 - Average Voltage [V]
2 - Frequency [Hz]
3 - Period [sec]
4 - Phase [deg]
5 - Amplitude [V]
6 - Low Voltage [V]
7 - High Voltage [V]
8 - Rise Time [sec]
9 - Fall Time [sec]
10 - Negative Pulse Width [sec]
11 - Positive Pulse Width [sec]
12 - Positive Duty Cycle [%]
13 - Negative Duty Cycle [%]
14 - Minimum Voltage [V]
15 - Maximum Voltage [V]
16 - Peak To Peak Voltage [V]

Notes:

(1) When measuring phase, make sure the instrument is in dual mode (phase shift between two channels is measured). The phase value is output in the form:
phase = source CH phase - complementary CH phase.
         This control specifies the source channel for the measurement.

Valid Values:
0 - CH1A  (Default Value)
1 - CH1B  (OX8027 only)
2 - CH2A
3 - CH2B  (OX8027 only)
     o    This control outputs the result of the measurement. All measured quantities are output in their basic units.
          Status                            $         Instrument Handle                  P .       Function                           P       Source                            8 P        Output                             	                          RMS Voltage 0 Average Voltage 1 Frequency 2 Period 3 Phase 4 Amplitude 5 Low Voltage 6 High Voltage 7 Rise Time 8 Fall Time 9 Neg Pulse Width 10 Pos Pulse Width 11 Pos Duty Cycle 12 Neg Duty Cycle 13 Minimum Vlotage 14 Maximum Voltage 15 Peak To Peak 16               8CH1A 0 CH1B (OX8027 only) 1 CH2A 2 CH2B (OX8027 only) 3    	          W    This function reads the trace data from the instrument.

Notes:

(1) If the acquisition of the oscilloscope runs, the oscilloscope doesn't respond to Read Trace query. To avoid this, stop the acquisition (function Trigger) before reading trace from the oscilloscope. Failing to stop acquisition before reading trace will result in an error.
    {    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Trace) out of range.

BFFC0803  Error Scanning Response

BFFC0900  Instrument specific error.
BFFC0901  Selected trace is not available.
BFFC0904  Attempt to read trace when acquisition is running.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None
        This control specifies the trace to be read out.

Valid Values:
0 - CH1A saved (Default Value)
1 - CH1B saved (OX8027 only)
2 - CH2A saved
3 - CH2B saved (OX8027 only)
4 - S1: signal 1 displayed
5 - S2: signal 2 displayed
6 - CH1AL:CH1A with Envelope Mode (Low Peak)
7 - CH1AH:CH1A with Envelope Mode (High Peak)
8 - CH1BL:CH1B with Envelope Mode (Low Peak) (OX8027 only)
9 - CH1BH:CH1B with Envelope Mode (High Peak) (OX8027 only)
10 - CH2AL:CH2A with Envelope Mode (Low Peak)
11 - CH2AH:CH2A with Envelope Mode (High Peak)
12 - CH2BL:CH2B with Envelope Mode (Low Peak) (OX8027 only)
13 - CH2BH:CH2B with Envelope Mode (High Peak) (OX8027 only)
    D    This control returns an array of values representing the trace data. The values are expressed in units of volts.

Notes:

(1) When reading traces S1, S2, the array must contain at least 1024 elements ViReal64[1024].

(2) When reading traces other than S1, S2, the array must contain at least 8192 elements ViReal64[8192].
         This control returns a number of samples of the trace data. If this function executes properly, it returns 8192 except for the traces S1, S2 (1024).
     M    This control returns the time origin of the trace data. It is always zero.
     f    This control returns the time difference between two samples of the trace data in units of seconds.
          Status                            
         Instrument Handle                  P .      Trace                             : P         Trace Data                         P        Number Of Samples                 %          t0                                z         dt                                 	                          CH1A 0 CH1B  (OX8027 only) 1 CH2A 2 CH2B  (OX8027 only) 3 S1 4 S2 5 CH1AL 6 CH1AH 7 CH1BL  (OX8027 only) 8 CH1BH  (OX8027 only) 9 CH2AL 10 CH2AH 11 CH2BL  (OX8027 only) 12 CH2BH  (OX8027 only) 13    	            	            	           	           n    This function writes commands and queries to the instrument to modify parameters and query device settings.
        The user can use this control to send common commands and queries to the instrument. This control can also be used to write any valid command to the instrument.

Default Value:  "*RST\n"

Notes:

(1) The command or query to be sent to the instrument may be a literal enclosed in double quotes i.e. "*RST" or may be contained in a variable of type string.

(2) Command strings must be terminated with Linefeed character (its ASCII code is 10, C language notation is "\n").
        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None
     M E      Write Buffer                            Status                            k         Instrument Handle                  	"*RST\n"    	              8    This function reads data from the instrument's output buffer and returns it to the specified variable in memory.

Notes:

(1) Because the instrument may return both numeric and text data in response to queries this function returns the data in string format.

(2) If valid data is not available at the instrument's output buffer when this function is called the instrument will hang up and the function will not return until it times out.  If the time-out is disabled this function will hang indefinitely and it may be necessary to reboot the computer to break out.
        The number of bytes specified by this control should be greater than or equal to the number of bytes which are to be read from the instrument. If the actual number of bytes to be read is greater than the number this control specifies then multiple reads will be required to empty the instrument's output buffer.

If the instrument's output buffer is not emptied the instrument may return invalid data when future reads are performed.

Default Value:  50 (See NOTE 2)

Notes:

(1) If NO DATA is available at the instrument's output buffer when this function is called the instrument will hang up and the function will not return until it times out.  If the time-out is disabled, this function will hang indefinitely and it may be necessary to reboot the computer.

(2) If the number of bytes expected is greater than 50 the value of this control may be increased. If the actual number of bytes read is larger than the declared size of the read buffer a run-time error will be generated.
        The incoming data from the instrument is placed into this variable.

Notes:

(1) Because the instrument may return both numeric and text data in response to queries this function returns the data in string format.

(2) This function does not overwrite any old data left in the string variable from the last time the function was called. String data in LabWindows/CVI is terminated with an ASCII null(0x0) and string manipulation functions will only recognize data before the ASCII null.

(3) The declared size of the string variable must be greater than the actual number of bytes read from the instrument if it is not a run-time error will be generated.
        This variable contains the actual number of bytes read from the instrument. This is the value which is returned by the read function.

Notes:

(1) If the actual number of bytes read is less than the number of bytes specified in the Number Bytes To Read control then the output buffer has probably been emptied. If the read function fails and the number of bytes read is 0, the most probable cause for the failure is there was no data available at the instrument's output buffer.
        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None
     M K        Number Bytes To Read                H      Read Buffer                       σ Mx        NumBytes Read                     l      Status                                     Instrument Handle                  50    	            	            	                   This function resets the instrument to a power-on default state.  Consult the user's manual for the default parameter settings to which this command resets the instrument.
        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None
    מ      Status                            C         Instrument Handle                  	               W    This function runs the instrument's self test routine and returns the test result(s).         This control contains the value returned from the instrument self test.  Zero means success.  For any other code, see the device's operator's manual.
         This control contains the string returned from the self test. See the device's operation manual for an explanation of the string's contents.

Notes:

(1) The array must contain at least 256 elements ViChar[256].
        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None
    ܼ = 2        Self Test Result                  \ =   ,    Self-Test Message                 :      Status                                     Instrument Handle                  	           	            	               F    This function reads an error code from the instrument's error queue.     N    This control returns the error code read from the instrument's error queue.
         This control returns the error message string read from the instrument's error message queue.

Notes:

(1) The array must contain at least 256 elements ViChar[256].
        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None
     = 2        Error Code                         =   ,    Error Message                           Status                            s         Instrument Handle                  	            	            	                   This function takes the Status Code returned by the instrument driver functions, interprets it and returns it as a user readable string.      u    This control accepts the Status Code returned from the instrument driver functions.

Default Value:
0 - VI_SUCCESS
         This control returns the interpreted Status Code as a user readable message string.

Notes:

(1) The array must contain at least 256 elements ViChar[256].
        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  VI_NULL
     =         Status Code                        =       Message                                 Status                            i         Instrument Handle                  0    	            	           VI_NULL   E    This function returns the revision numbers of the instrument driver and instrument firmware, and tells the user with which  instrument firmware this revision of the driver is compatible. 

This instrument driver's Revision Number is "Rev 2.0, 02/1999, CVI 5.0.1" and is compatible with Instrument Firmware Revision "1.33".
         This control returns the Instrument Driver Software Revision.

Notes:

(1) The array must contain at least 256 elements ViChar[256].
         This control returns the Instrument Firmware Revision.

Notes:

(1) The array must contain at least 256 elements ViChar[256].
        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None
    U = 2       Instrument Driver Revision         =,       Firmware Revision                 l      Status                                     Instrument Handle                  	            	            	               E    This function controls the instrument's front panel lockout state.
        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Mode) out of range.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None
     i    Controls the front panel lockout.

Valid Values:
VI_OFF (0) - Unlock (Default Value)
VI_ON  (1) - Lock
          Status                                     Instrument Handle                 k N        Mode                               	               Lock VI_ON Unlock VI_OFF        This function performs the following operations:
viClose (instrSession) and viClose (rmSession).

Notes:

(1) The instrument must be reinitialized to use it again.
        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None
    U      Status                                    Instrument Handle                  	                        H     K.    init                                     #  /     K.    example                                  3  ;M     K.    readWriteSetup                           <R  B     K.    autoScale                                C6  L     K.    confAcq                                  N  W     K.    confInp                                  YM  e     K.    confHoriz                                h  q     K.    confSaveTrace                            s9       K.    confDisp                                        K.    confTrig                                        K.    trigger                                  A       K.    measure                                  (       K.    readTrace                                n       K.    writeInstrData                             ձ     K.    readInstrData                                   K.    reset                                    ]       K.    selfTest                                 {       K.    errorQuery                                      K.    errorMessage                                    K.    revisionQuery                                   K.    frontPanLock                                   K.    close                                                                      DInitialize                          Application Functions                DExample                             Configuration Functions              DRead/Write Setup                     DAutoscale                            DConfig Acquisition                   DConfig Input                         DConfig Horizontal                    DConfig Save Trace                    DConfig Display                       DConfig Trigger                      
6Action/Status Functions              DTrigger                             :Data Functions                       DMeasure                              DRead Trace                          EUtility Functions                    DWrite To Instrument                  DRead Instrument Data                 DReset                                DSelf-Test                            DError-Query                          DError Message                        DRevision Query                       DFront Panel Lockout                  DClose                           