/*= PROTOTYPES =================================================================*/

int ox8020_init (int ,int ,int ,int ,int ,int ,int);
int ox8020_setup (int ,int ,int ,char * );
int ox8020_cont_inst (int , int );
int ox8020_channel (int ,int ,int ,int);
int ox8020_channel_save (int , int );
int ox8020_acquire (int ,int ,int ,int ,int ,int);
int ox8020_display (int ,int ,int ,int ,int ,int );
int ox8020_timebase (int ,int ,int ,int );
int ox8020_trigger (int ,int ,int ,int );
int ox8020_wave_read (int ,int , int, int ,double [], char *);
int ox8020_measure (int ,int );
int ox8020_status (int ,int );
int ox8020_instrument_query (int, int );
int ox8020_close (void);

int ox8020_write_data(char *);
int ox8020_read_data(char * , int);

/*= GLOBALS ===============================================================*/
extern double  ox8020_xscale;          /* Time interval between two samples       */
extern double  ox8020_yscale;          /* Voltage interval between two quantums   */
extern double  ox8020_yoffset;         /* Position of OV (GND)                    */
extern int     ox8020_size;            /* Size of the wave read                   */
extern int     ox8020_npoint;          /* Number of samples in the wave           */
extern int     ox8020_err;             /* Error number                            */
extern int     ox8020_port;            /* Number of serial port                   */
extern int     ox8020_instrument;      /* N of instrument (8020 or 8027)         */
extern int     ox8020_version;         /* Software Version of instrument          */
extern int     ox8020_indice;          /* Software indice of version              */
extern char    ox8020_state[60];       /* Response to instrument queries          */
extern char    ox8020_mesure[20];      /* Response to automatic measurements      */
extern char    ox8020_header[200];     /* Header of waveforms                     */
