s              $                                          ox8020      Metrix OX8020 & OX8027                               Instrument name: Metrix OX8020/8027

   Description: This instrument module provides
                GPIB and RS232 support for OX8020
                and OX8027.

                The module contains the followings
                functions:

        (1) Initialize
                Initialize the instrument module
                 and the communication.

        (2) Configuration
                Class of functions for configuring
                the following parameters:

                        * Save/Recall Setup
                        * Mode && Autoset
                        * Channel Settings
                        * Channel Save
                        * Acquisition settings
                        * Display settings
                        * Timebase settings
                        * Trigger

        (3) Analyse
                Class of functions for configuring
                the following parameters:

                        * Waveform Read
                        * Automatic Measurements
                        * IEEE 488.2 queries
                        * Instrument queries

        (4) Close
                Close the instrument module and
                unlock the front panel .    ~            Class name   :  Configure

        Description  :

        Class of functions for setting the
        following parameters:

            * Save & Recall Setup
            * MODE & AUTOSET
            * Input Settings
            * Channel Save
            * Acquisition Settings
            * Display Settings
            * Timebase Settings
            * Trigger Settings             Class name  : Analyse

    Description : Class of functions for reading:

        * Waveform
        * Automatic Measurements
        * IEEE 488.2 status
        * Instrument Settings
    	            Panel name : Initialize

        Description :

            * Open the communication (IEEE or
              RS232) with the right parameters :

                IEEE : adress
                RS232: serial port number
                       speed,parity

            * Identify the device (OX8020 or 8027)
            * Clear Status (*CLS)

            * If enabled , reset the device (*RST)
            * If enabled , lock the front pannel


        Default Instrument Setup (after *RST) :

        Memory                  :   Off
        Front pannel            :   Unlocked
        Communication           :   PC


        Input Settings
            CH1/CH2 coupling    :   AC
            CH2 inversion       :   Off
            Input Range         :   0.1V/DIV

        Channel Save
            CH1A                :   Off
            CH1B                :   Off
            CH2A                :   Off
            CH2B                :   Off

        Acquisition Settings
            Mode                :   REFRESH
            Pre-trigger         :   0ko
            Peak                :   Off
            Run/Stop            :   Stop
            Glitch capture      :   Off (OX8027)

        Display Settings
            Mode                :   CHOP
            Bank                :   A
            Horizontal expansion:   x1
            Window position     :   0000
            Interpolation       :   Off
            Y filtering         :   NO

        Timebase Settings
            x10                 :   Off
            Auto                :   On
            Delay               :   Off
            Range               :   50S/DIV

        Trigger Settings
            Mode P-P            :   Off
            Slope               :   +
            Source              :   CH1
            Coupling            :   DC

        Data format
            Format              :   ASCII
            Header ADIF         :   Off

        Hardcopy Settings
            format              :   Plot
            Grid                :   Off
            Screen sharing      :   Off
            Status              :   Off

        Measures Settings
            Cursors             :   C1
            Measure             :   Off
            H cursors position  :  C1: -4 DIV
                                   C2: +4 DIV
            V cursors position  :  C1: -5 DIV
                                   C2: +5 DIV
                                   C3:  0 DIV
            Reference           :  CH1


             Control label  : Interface

    Description    : Defines the interface type

    Variable type  : integer

    Variable range :    0 : IEEE
                        1 : RS232  (default value)
    "      Control Name:  Reset

  Description:   Specifies if the instrument is to
                 be reset to its default settings
                 during the initialization
                 procedure.

  Variable Type: Integer

  Valid Range:   1 = Yes (default value)
                 0 = No
         Control Name:  Lock Front Panel

 Description:   Specifies if the Front Panel is to
                be locked or unlocked during the
                initialization procedure.

 Variable Type: Integer

 Valid Range:   1 = Yes
                0 = No   (default value)

 Warning : If you do not lock the front panel and
           modify the setup of the instrument from
           its front panel , the driver does not
           know this new setup and some errors may
           be wrongs or not seen .            Control label  : GPIB Address

    Description    : Specifies the GPIB address of
                     the scope as configured in
                     its MENU (IEEE option) .

    Variable type  : integer

    Variable range : 0 to 30  (Default value : 1)
             Control label  : RS232 port number

    Description    : Defines the RS232 port number

    Variable type  : integer

    Variable range : 1 to 8 (default value 1)
    
     Control Name:  Baud Rate

 Description:   Specifies  the baud rate at which
                to communicate with the
                instrument.

 Variable Type: Integer

 Valid Values:  110,150,300,600,1200,2400,4800,
                9600 bauds

 Default Value: 9600         Control Name:  Parity

 Description:   Specifies the parity mode to
                be used to communicate with the
                instrument.

 Variable Type: Integer

 Valid Values:  0 - no parity  (default value)
                1 - odd parity
                2 - even parity    H        Control label  :  Error

    Description    :  Displays the result of the
                      function call.

    Variable type  :  global integer

    Variable range :

          0  :  Success
         -1  :  Interface out of range
         -2  :  Reset Device out of range
         -3  :  Lock Front Pannel out of range
         -4  :  GPIB address out of range
         -5  :  RS232 port out of range
         -6  :  Baud Rate out of range
         -7  :  Parity out of range
         -8  :  Error interpreting instrument
                response

    (Error Code - 300) =  1 to 124

    1 - 124     RS-232 error (see RS-232 Library
                error codes)

        220  :  Unable to open Instrument
        230  :  Write Error
        231  :  Read Error
        233  :  Error in setting GPIB primary
                address    g - R           Interface                         4 -           Reset Device                      ^ -          Lock Front Panel                  _            GPIB address                      n            RS232 port number                   S          Baud Rate                         5           Parity                            W          Error                            H                                            /                                           RS232 1 IEEE 0   Reset Device 1 Don't Reset 0   On 1 Off 0    1                1 1 2 2 3 3 4 4 5 5 6 6 7 7 8 8              H110 110 150 150 300 300 600 600 1200 1200 2400 2400 4800 4800 9600 9600               none 0 odd 1 even 2    	            	(OX8027)    	(OX8027)            Panel name  :   Instrument Setup

    Description :   This panel is usefull to
                    Save or Recall the instrument
                    Setup to or from RAM or
                    file .            Control label  :  RAM Number

    Description    :  Selects the number of
                      the Setup to be stored
                      or recalled.

    Variable type  :  integer

    Variable range :  from 1 to 10
                      (default value : 1)    
        Control label  :  Configuration

    Description    :  Selects the Save or Recall
                      Instrument Setup function .

    Variable type  : integer

    Variable range :
                     0 : Save   (default value)
                     1 : Recall             Control label  :  Configuration

    Description    :  Selects the target (RAM or
                      File)

    Variable type  : integer

    Variable range :  0 : RAM   (default value)
                      1 : File    X        Control label  :  Filename

    Description    :  Specify the filename of the
                      file containing the device
                      setup.

    Variable type  :  String

    Note : Syntaxe with C language : if you
    specify the complete pathname , you have to
    write \\ instead of \ :

                c:\\lw\\setup
    +        Control label  :  Error

    Description    :  Displays the result of the
                      function call.

    Variable type  :  global integer

    Variable range :

                  0  :  Success
                 -1  :  Setup out of range
                 -2  :  Storage out of range
                 -3  :  RAM number out of range
                 -4  :  Error Opening file
                 -5  :  Nothing in this RAM

                230  :  Write Error
                231  :  Read Error
                232  :  Instrument not initialized      =@         RAM number                        ! ] Q           Setup                             " ^           Storage                           # U         Filename                          %          Error                                      
   *1 1 2 2 3 3 4 4 5 5 6 6 7 7 8 8 9 9 10 10              Recall 1 Save 0               
RAM 0 File 1    "c:\\temp\\setup1"    	           y            Panel name  :   MODE & AUTOSET

        Description :   This panel  is usefull to
                        switch the MODE (analo-
                        gical or numeric) and to
                        run the AUTOSET function
                        (look for the right
                        settings to display the
                        signal on the screen).
             Control label  : Instrument mode

    Description    : Defines the oscilloscope mode

    Variable type  : integer

    Variable range :

                0 :     Analogical mode (default value)
                1 :     Digital Storage mode
    +        Control label  : AUTOSET

    Description    : Run the automatic scaling
                     function .

    Variable type  : integer

    Variable range :  0  :       Autoscale OFF (default value)
                      1  :       Autoscale ON

 NOTE :  The autoscale function analyses the
         input signals and sets time
         base range (according to the
         slowest signal),vertical range,
         trigger source and display mode .
         If no signal is present , the
         instrument recalls its previous
         settings .    c        Control label  :  Error

    Description    :  Displays the result of the
                      function call.

    Variable type  : integer

    Variable range :

             0  :   Success
            -1  :   Mode out of range
            -2  :   Autoset out of range
            230 :   Write error
            232 :   Instrument not initialized    *e ] |           Mode                              +b ]+            Autoset                         -          Error                              NUM 1 AN 0    On 1 Off 0    	           1            Panel name  :   Inputs Settings

        Description :   This panel is usefull to
                        set the channels CH1 and
                        CH2 parameters.

            * Coupling   :    AC,DC,GND
            * Range      :    20V/DIV..1mV/DIV
            * Invert CH2 :    Off,On    '        Control label  : Channel number

    Description    : This control selects the
                     channel of which parameters
                     have to be modified.

    Variable type  : integer

    Variable range :     1:     CH1 (default value)
                         2:     CH2
            Control label  : Coupling

    Description    : This control sets the
                     coupling for the selected
                     channel.

    Variable type  : integer

    Variable range :  0  AC  (default value)
                      1  DC
                      2  GND
    (        Control label  : Range

    Description    : This parameter defines the
                     range (Volt/div) of the
                     selected channel

    Variable type  : integer

    Variable range : 0    1mV/DIV
                     13   20V/DIV

    Default Value  : 6    0.1V/DIV
             Control label  : Invert CH2

    Description    : Defines the CH2 inversion
                     state.

    Variable type  : integer

    Variable range :  0:  OFF (default value)
                      1:  ON            Control label  :  Error

    Description    :  Displays the result of the
                      function call.

    Variable type  : integer

    Variable range :

             0  :   Success
            -1  :   Channel out of range
            -2  :   Coupling out of range
            -3  :   Range out of range
            -4  :   Invert CH2 out of range
            230 :   Write error
            232 :   Instrument not initialized    1  M a           Channel (N)                       2/ M          COUPling                          3U M         RANGe                             4            INVert CH2                        5d          Error                                         CH1 1 CH2 2               AC 0 DC 1 GND 2              i1 mV 0 2 mV 1 5 mV 2 10 mV 3 20 mV 4 50 mV 5 0.1 V 6 0.2 V 7 0.5 V 8 1 V 9 2 V 10 5 V 11 10 V 12 20 V 13    On 1 Off 0    	                       Panel name  :   Channel save

        Description :   This panel is usefull to
                        Save or not a channel.

                        Saving a channel prevent
                        from an undesirable
                        writing in its memory.            Control label  : Save

    Description    : This control selects the
                     channel whom save state
                     has to be modified.

    Variable type  : integer

    Variable range :    OX8027       OX8020
                        0:CH1A       0: CH1    (default value)
                        1:CH1B       1: CH1
                        2:CH2A       2: CH2
                        3:CH2B       3: CH2            Control label  : Save State

    Description    : This control valids or not
                     the save function of the
                     selected channel.

    Variable type  : integer

    Variable range :    0:  OFF (default value)
                        1:  ON            Control label  :  Error

    Description    :  Displays the result of the
                      function call.

    Variable type  : integer

    Variable range :

             0  :   Success
            -1  :   SAVE out of range
            -2  :   Save state out of range
            -3  :   Acquisition Running (Select
                    Acquisition Pannel and Stop
                    it)
            230 :   Write error
            232 :   Instrument not initialized    : m            SAVE                              ; m9          Save state                        <          Error                            X D                                          h Y                                          x Y                                           Y                                           Y                                                       CH1A 1 CH1B 2 CH2A 3 CH2B 4    On 1 Off 0    	            	(OX8020)    CH1    CH1    CH2    CH2                Panel name  :   Acquisition settings

        Description :   This panel is usefull to
                        configure and control the
                        acquisition process.
                        The following parameters
                        can be set:

            * Acquisition MODE:SINGLE,REFRESH,ROLL
            * Envelop mode (OFF or ON)
            * GLITCH capture (OFF or ON)
            * Pre-trigger depth
                  OX8020 :  0..4ko
                  OX8027 :  0..8ko

    >        Control label  : Acquisition Mode

    Description    : This control sets the
                     acquisition mode in single,
                     refresh or roll mode.

    Variable type  : integer

    Variable range : 0 : SINGLE 
                     1 : REFRESH (default value)
                     2 : ROLL    i        Control label  : PRETRIG

    Description    : this control sets the pretrig
                     value.

    Variable type  : integer

    Variable range :

          OX8020     -1     : Continuous ROLL
                     0 to 4 : 0k to 4ko

          OX8027     -1     : Continuous ROLL
                     0 to 8 : 0k to 8ko

    Default value  : 0k             Control label  : control

    Description    : this parameter runs or
                     stops the acquisition process

    Variable type  : integer

    Variable range : 0 : Stop (default value)
                     1 : Run
             Control label  : PEAK

    Description    : This control valids or not
                     the envelop mode .

    Variable type  : integer

    Variable range : 0 : OFF (default value)
                     1 : ON
            Control label  : GLITCH

    Description    : This control sets the
                     Glitch Capture mode (availa-
                     ble with OX8027 only).

    Variable type  : integer

    Variable range : 0 : Off (default value)
                     1 : On
            Control label  : *WAI

    Description    : When ON , the oscilloscope
                     waits for the end of acquisi-
                     tion before executing next
                     orders stored in its input
                     buffer . This function is
                     usefull when you need the
                     result of the acquisition
                     (for example : reading wave-
                     form or automatic measure-
                     ments) . Available with
                     Single only .

    Variable type  : integer

    Variable range : 0 : OFF (default value)
                     1 : ON
    X        Control label  : Error

    Description    :  Displays the result of the
                      function call.

    Variable type  : integer

    Variable range :

             0  :   Success
            -1  :   MODE out of range
            -2  :   REFerence out of range
            -3  :   PEAK out of range
            -4  :   RUN/STOP out of range
            -5  :   *WAI out of range
            -6  :   GLITch out of range
            -7  :   ROLL not allowed with timebase
                    faster than 500mS/Div.
            -8  :   REFerence -1 allowed with ROLL
            -9  :   PEAK allowed with REFRESH only and
                    timebase < 200mS/Div
           -10  :   *WAI allowed with SINGLE only
           -11  :   GLITch avalaibale with OX8027

            230 :   Write error
            232 :   Instrument not initialized    B  u           MODE                              D3           REFerence                         E           RUN/STOP                          F m           PEAK                              Gz m          GLITch                            H            *WAI                              K!          Error                            xG                                                      Single 0 Refresh 1 Roll 2           
   NUnint. ROLL -1 0 Ko 0 1 Ko 1 2 Ko 2 3 Ko 3 4 Ko 4 5 Ko 5 6 Ko 6 7 Ko 7 8 Ko 8  
  Run 1 Stop 0    On 1 Off 0    On 1 Off 0    On 1 Off 0    	            	(OX8027)   X            panel name  :   Display settings

        description :   This panel is usefull to
                        configure and control the
                        format of the display.
                        The following parameters
                        can be set here :

  Mode          :     CH1 ALT CHOP CH2 XY ADD MULT
  Bank          :       A   B   AB  BA
  H Exp         :     OX8020:    x0.2..x20
                      OX8027:    x0.1..x20
  H Position    :     OX8020:    0..4000
                      OX8027:    0..8000
  Interpolation :     Off,LN,SN
  Y Filter      :     Off,On            Control label  : MODE

    Description    : This control configures the
                     vertical display mode of the
                     scope.

    Variable type  : integer

    Variable range : 0 : CH1  (default value)
                     1 : ALT
                     2 : CHOP
                     3 : CH2
                     4 : XY
                     5 : ADD
                     6 : MULT  (*)

  * MULT is not allowed in analogical scope mode.            Control label  : Bank

    Description    : This control configures the
                     bank used. Available in
                     Ox8027 only

    Variable type  : integer

    Variable range : 0 : Bank A (default value)
                     1 : Bank B
                     2 : Banks A and B
                     3 : Banks B and A (*)
    (*) Useful if you want to display CH1B and
        CH2A  .            Control label  : HOR_EXP

    Description    : This control configures the
                     horizontal expansion in
                     numerical mode.

    Variable type  : integer

    Variable range :

 OX8020 :       x0.2, x0.5, x1, x2, x5, x10, x20
 OX8027 : x0.1, x0.2, x0.5, x1, x2, x5, x10, x20

    (default value : x1)

   Warning : if you have acquired a signal at a
   range faster  5s/Div (2s..0.1S) , then :

        x1  will set the time base to 2s/div
        x2  will set the time base to 1s/div
        x5  will set the time base to 0.5s/div
        x10 will set the time base to 0.2s/div
        x20 will set the time base to 0.1s/div    -        Control label  : HOR_POS

    Description    : This control configures the
                     window position in numerical
                     mode.

    Variable type  : integer

    Variable range : 0 to 4000  with OX8020
                     0 to 8000  with OX8027

    Default value  : 0
    0        Control label  : Interpolation

    Description    : This control sets the type of
                     interpolation (Digital
                     Storage Display).

    Variable type  : integer

    Variable range : 0 : Off (default value)
                     1 : LN
                     2 : SN
            Control label  : Filter

    Description    : This control sets the Y
                     filtering (Digital Storage
                     Display)

    Variable type  : Integer

    Variable range : 0 : OFF (default value)
                     1 : ON            Control label  :  Error

    Description    :  Displays the result of the
                      function call.

    Variable type  : integer

    Variable range :

             0  :   Success
            -1  :   MODE out of range
            -2  :   Bank out of range
            -3  :   HOR_EXP out of range
            -4  :   HOR_POS  out of range
            -5  :   Interpolation out of range
            -6  :   Filter out of range
            -7  :   MULT not available in AN mode
            -8  :   Bank BA not available with
                    CH1 or CH2 Display Mode
            -9  :   HOR EXP <>3 (x1) not available
                    when Acquisition is running

            230 :   Write error
            232 :   Instrument not initialized
    Sa - 6          MODE                              U8 -\          Bank                              V  6         HOR_EXP                           Y           HOR_POS                           Z  ~          Interpolation                     [ 2          Filter                            \          Error                            x                                                       +CH1 0 ALT 1 CHOP 2 CH2 3 XY 4 ADD 5 MULT 6               A 0 B 1 AB 2 BA 3              0x0.1 0 x0.2 1 x0.5 2 x1 3 x2 4 x5 5 x10 6 x20 7    0               Off 0 LN 1 SN 2    On 1 Off 0    	            	(OX8027)   y            Panel name  :   Time base

        Description :   This panel is usefull to
                        configure Time base
                        parameters :

    X10         :   Off,On
    Mode AUTO   :   Off,on
    Delay       :   Off,Search,Delay
    Range       :   200S/DIV ..0.1S/DIV  (Numerical mode)
                    200mS/DIV ..0.5S/DIV (Analogical mode)    F        Control label  : EXPH (x10)

    Description    : This control configures the
                     horizontal x10 expanded mode
                     This mode is useful only
                     in analogical mode.

    Variable type  : integer

    Variable range : 0 : OFF (default value) 
                     1 : ON
            Control label  : AUTO

    Description    : This control configures the
                     trigger in AUTOmatic mode
                     or triggered mode.

    Variable type  : integer

    Variable range : 0 : NORMAL (default value) 
                     1 : AUTO
            Control label  : Delay

    Description    : This control configures the
                     delayed time base state.

    Variable type  : integer

    Variable range : 0 : OFF (default value)
                     1 : SEARCH
                     2 : DELAY
            Control label  : Range

    Description    : Defines the speed of the time
                     base.

    Variable type  : integer

    Variable Range :    0:    0.1S/DIV
                       28:     200S/DIV
                       (1,2,5 sequences)

    Default value  :    7:     20s/DIV

NOTE :  Analogical mode  : 0.5E-6 to 200E-3
        Numerical mode   : 0.1E-6 to 200    >        Control label  :  Error

    Description    :  Displays the result of the
                      function call.

    Variable type  : integer

    Variable range :

             0  :   Success
            -1  :   EXPH out of range
            -2  :   MODE out of range
            -3  :   DELay out of range
            -4  :   RANGe out of range
            -5  :   RANGe not allowed with ROLL
            -6  :   RANGe not allowed with AN
            -7  :   SEARCH not allowed with NUM

            230 :   Write error
            232 :   Instrument not initialized
    d
 -            EXPH (x10)                        eX -$          MODE                              fs            DELay                             g          RANGe                             i
          Error                              ON 1 OFF 0    AUTO 1 NORM 0               OFF 0 SEARch 1 DELay 2              0.1 s 0 0.2 s 1 0.5 s 2 1 s 3 2 s 4 5 s 5 10 s 6 20 s 7 50 s 8 0.1 ms 9 0.2 ms 10 0.5 ms 11 1 ms 12 2 ms 13 5 ms 14 10 ms 15 20 ms 16 50 ms 17 0.1 s 18 0.2 s 19 0.5 s 20 1 s 21 2 s 22 5 s 23 10 s 24 20 s 25 50 s 26 100 s 27 200 s 28    	           S            Panel name  :   Trigger

        Description :   This panel is usefull to
                        configure the trigger
                        parameters.

            These parameters are :

   P-P Mode     :   Off,On
   Slope        :   +,-
   Source       :   CH1 CH2 ALT LINE EXT
   Coupling     :   DC  AC  LF  HF   TVH TVV             Control label  : Peak to peak

    Description    : Defines the trigger P-P mode

    Variable type  : integer

    Variable range : 0 : NORM (default value)
                     1 : PTP
             Control label  : Slope

    Description    : Defines the trigger slope
                     Positif or negatif

    Variable type  : integer

    Variable range : 0 : + (default value)
                     1 : -
            Control label  : Source

    Description    : Defines the trigger source

    Variable type  : integer

    Variable range : 0 : CH1 (default value)
                     1 : CH2
                     2 : ALT
                     3 : LINE
                     4 : EXT
    H        Control label  : Coupling

    Description    : Defines the trigger input
                     coupling.

    Variable type  : integer

    Variable range : 0 : DC (default value)
                     1 : AC
                     2 : LF
                     3 : HF
                     4 : TVH
                     5 : TVV
            Control label  :

    Description    :  Displays the result of the
                      function call.

    Variable type  : integer

    Variable range :

             0  :   Success
            -1  :   MODE out of range
            -2  :   SLOPe out of range
            -3  :   SOURCe out of range
            -4  :   COUPling out of range
           230  :   Write error
           232  :   Instrument not initialized

    o	 -            MODE                              o -9          SLOPe                             p           SOURce                            q           COUPling                          s          Error                            
  PTP 1 NORM 0   + 0 - 1               CH1 0 CH2 1 ALT 2 LINE 3 EXT 4                DC 0 AC 1 LF 2 HF 3 TVH 4 TVV 5    	           %            Panel name  :   Read Waveform

        Description :   This panel is useful for
                        reading waveforms and
                        storing its either in
                        an array or in a file.


         Note : About the header...

 The header contains scale informations and helps
 you to graduate the axis for representings the
 signals . Once the Waveform Read is executed ,
 the variables ox8020_xscale , ox8020_yscale and
 ox8020_yoffset are updated .

   ox8020_xscale represents the time interval
   between two samples (in Second).

     Example : if you want to display 1000 points
     on the screen , the X axis length is
     1000*ox8020_xscale.

   ox8020_yscale represents the voltage between
   two quantums (ADC 8 bits==> 256 quantums).
   200 quantums are displayed on the oscilloscope
   screen (+-100) (25 quantums/DIV).

     Example : if you want to display 8 Divisions
     on the Y axis , the minimum value for the
     Y axis is (-100*ox8020_yscale) and the
     maximum value is (100*ox8020_yscale).
            Control name  : Waveform

    Description   : Selects the waveform to be
                    read.

    Variable type : integer

    Valid range   :    OX8027             OX8020
                       0  CH1A            0  CH1 (default value)
                       1  CH1B            1  CH1
                       2  CH2A            2  CH2
                       3  CH2B            3  CH2
                       4  S1              4  S1
                       5  S2              5  S2

     where S1 represents the signal displayed on
     the screen and whose parameters are displayed
     at the left top corner (S2 is the other
     signal (if present)).            Control label  : Data Interchange Format

    Description    : This control specifies if the
                     header is sent by the device
                     before the trace data .

    Variable type  : integer

    Variable range : 0: OFF (default value)
                     1: ON

Note : the header contains the scale informations
       (x,y) and the 0 Volt position. See your
       Programming Reference Manual for more
       informations .            Control label  : Peak

    Description    : This control specifies the
                     Peak (Min or Max) of the
                     channel to be read .

    Variable type  : integer

    Variable range : 0: Min (default value)
                     1: Max    
        Control label  : Store in File?

    Description    : This control specifies if the
                     samples are recorded in a
                     file .

    Variable type  : integer

    Variable range : 0: No (default value)
                     1: Yes    b        Control label  : Output Array

    Description    : Defines the array in which
                     samples have to be stored .

    Variable type  : double array

    Variable range : Any existing array name

    Size :  Waveforms S1 and S2 : 1024
            All others          : 4096 for OX8020
                                : 8192 for OX8027             Control name  : Filename

    Description   : Specifies the filename (with
                    its pathname) to which the
                    samples are writen .

    Variable type : String (default value : c:\\temp\\wave.dat)            Control name : Count

    Description  : Returns the number of bytes
                   read .

    Variable type: integer

    Valid range  : Waveform S1,S2: 1024
                   All others    : 4096 for OX8020
                                   8192 for OX8027            Control label  :  Error

    Description    :  Display the result of the
                      function call.

    Variable type  : integer

    Variable range :

             0  :   Success
            -1  :   Waveform out of range
            -2  :   Header out of range
            -3  :   Peak out of range
            -4  :   Store in File out of range
            -5  :   Peak not available with S1/S2
            -6  :   S2 not displayed on screen
            -7  :   Peak MAX or MIN not available
            -8  :   Unable to Open File
            230 :   Write error
            231 :   Read error
            232 :   Instrument not initialized

            Others : See iberr    z - w           Waveform                          }, -           Header                              -          Peak                               -          Store in File?                    %  *         Output Array                                 File Name                          9         Count                                       Error                                                                       (                                           8                                           H                                           X                                                        &CH1A 0 CH1B 1 CH2A 2 CH2B 3 S1 4 S2 5    On 1 Off 0    Max 1 Min 0    Yes 1 No 0        "c:\\temp\\wave.dat"    	                    ox8020_err    	(OX8020)    CH1    CH1    CH2    CH2               Panel name  :   Automatic Measurements

        Description :   This panel is useful to
                        run and read the automa-
                        tics measurements .

            Measurements :

        Reference:  OX8020 : CH1 CH2
                    OX8027 : CH1a CH1b CH2a CH2b

        Type:       AC
                    DC
                    FREQuency
                    PERiod
                    PHASe
                    AMPLitude
                    LOW
                    HIGH
                    RISE:TIMe
                    FALL:TIMe
                    NWIDth
                    PWIDth
                    PDUTy
                    NDUTy
                    MINimum
                    MAXimum
                    PTPeak            Control label  : Measure control

    Description    : This control defines the
                     type of measurement .

    Variable type  : integer

    Variable range : The measures available are :

             0       AC          (default value)
             1       DC
             2       FREQuency
             3       PERiod
             4       PHASe
             5       AMPLitude
             6       LOW
             7       HIGH
             8       RISE:TIMe
             9       FALL:TIMe
            10       NWIDth
            11       PWIDth
            12       PDUTy
            13       NDUTy
            14       MINimum
            15       MAXimum
            16       PTPeak            Control label  : Reference

    Description    : This control defines the
                     waveform to be measured.

    Variable type  : integer

    Variable range : OX8020         OX8027
                     1 CH1          1 CH1a (default value)
                     2 CH2          2 CH1b
                                    3 CH2a
                                    4 CH2b            Control label  :  Error

    Description    :  Displays the result of the
                      function call.

    Variable type  : integer

    Variable range :

             0   :  Success
            -1   :  Measure Control out of range
            -2   :  Reference out of range
           230   :  Write error
           231   :  Read error
           232   :  Instrument not initialized             Control label  : Measure value

    Description    : Diplays the result of the
                     measurement .

    Variable type  : string

     M T          Measure Control                    Mf          Reference                         %          Error                                       Measure value                    8                                          H                                          X                                          8                                          H                                          X                                          h                                          x                                                       AC 0 DC 1 FREQuency 2 PERiod 3 PHASe 4 AMPLitude 5 LOW 6 HIGH 7 RISE:TIMe 8 FALL:TIMe 9 NWIDth 10 PWIDth 11 PDUTy 12 NDUTy 13 MINimum 14 MAXimum 15 PTPeak 16               1 1 2 2 3 3 4 4    	                    ox8020_mesure    OX8020    CH1    CH2    OX8027    CH1a    CH1b    CH2a    CH2b               Panel name  :   IEEE 488.2 Queries

        Description :   This panel is usefull to
                        read some status of the
                        scope.

        *ESE?   (event status enable)
        *ESR?   (Event status register)
        *IDN?   (Scope Identification)
        *LRN?   (System setup)
        *OPC?   (Operation Complete)
        *SRE?   (Service request Mask)
        *STB?   (Status byte)
        *TST?   (Emulate a test of the scope)            Control label  : Queries/Commands

    Description    : Defines the type of IEEE
                     query to be sent OR sets
                     the Enable Register (event
                     or status register).

    Variable type  : integer

    Variable range :   0 to 9

        Queries (from 0 to 7)

        0 :  *ESE?   (Event status enable) (default value)
        1 :  *ESR?   (Event status register)
        2 :  *IDN?   (Scope Identification)
        3 :  *LRN?   (System setup)
        4 :  *OPC?   (Operation END)
        5 :  *SRE?   (Service request Mask)
        6 :  *STB?   (Status byte)
        7 :  *TST?   (Emulate a test of the scope)

        Commands (from 8 to 9)

        8 :  *ESE<NRf> (Set Event status enable)
        9 :  *SRE<NRf> (Set Event status register)            Control label  : Mask Value

    Description    : Used with the commands *ESE and *SRE to 
                     set the Event Status Enable and Service
                     Request Enable registers.

    Variable type  : integer

    Variable range :   0 to 0xFF (default value)

            Control label  :  Error

    Description    :  Displays the result of the
                      function call.

    Variable type  : integer

    Variable range :
             0  :   Success
            -1  :   Queries/Commands out of range
            -2  :   Mask Value out of range
            230 :   Write error
            231 :   Read error
            232 :   Instrument not initialized     o        Control label  : Return status

    Description    : Displays the answer .

    Variable type  : string

     =            Queries/Commands                   $          Mask Value                        8          Error                              M$        Return status                              
   X*ESE? 0 *ESR? 1 *IDN? 2 *LRN? 3 *OPC? 4 *SRE? 5 *STB? 6 *TST? 7 *ESE<NRf> 8 *SRE<NRf> 9    0xFF    	                    ox8020_state                Panel name  :   Instrument Queries

        Description :   This panel is usefull to
                        read the instrument
                        settings.

             Control label  :  Query

    Description    : This control defines which
                     query has to be sent to the
                     instrument .

    Variable type  : integer


    Variable range : 0 to 29
  
    Default value  : 0 (MODE?)            Control label  : Channel

    Description    : This control defines which
                     channel setup has to be
                     read.
                     (when using DISP:SAVE<N>? queries) .

    Variable type  : integer

    Variable range : 1..4

                     ox8020          ox8027
                     1:  CH1         1: CH1A (default value)
                     2:  CH1         2: CH1B
                     3:  CH2         3: CH2A
                     4:  CH2         4: CH2B            Control label  :  Error

    Description    :  Displays the result of the
                      function call.

    Variable type  : integer

    Variable range :

             0  :   Success
            -1  :   Query out of range
            -2  :   Channel (<N>) out of range
            230 :   Write error
            231 :   Read error
            232 :   Instrument not initialized             Control label  : Result

    Description    : This value display the result
                     of the last read.

    Variable type  : string
    d M T          Query                             l            <N>                               o          Error                               ]\        Result                                                                                                                                                                                                                                                            !  MODE? 0 ACQ:GLITch? 1 ACQ:MODE? 2 ACQ:PEAK? 3 ACQ:REF? 4 DISP:ANN? 5 DISP:FILT? 6 DISP:MODE? 7 DISP:SAV<N>? 8 TRACE:FEED? 9 TRAC:X:LEFT? 10 TRAC:X:PDIV? 11 FORMat? 12 FORMat:DINT? 13 INP1:COUP? 14 INP1:RANG? 15 INP1:VERN? 16 INP2:COUP? 17 INP2:INV? 18 INP2:RANG? 19 INP2:VERN? 20 OUTP:FILT? 21 SYST:ERR? 22 SYST:KLOCk? 23 SYST:VERS? 24 TIM:DEL? 25 TIM:EXPH? 26 TIM:MODE? 27 TIM:RANGe? 28 TRIG:COUP? 29 TRIG:MODE? 30 TRIG:SLOPe? 31 TRIG:SOURce? 32               CH1A 1 CH1B 2 CH2A 3 CH2B 4    	                    ox8020_state    	(OX8020)    CH1    CH1    CH2    CH2    }        Function name : Close

    Description   : Close the instrument module
                    and unlock the front pannel.            Control label  :  Error

    Description    :  Displays the result of the
                      function call.

    Variable type  : integer

    Variable range :

            0   :   Success
            221 :   Unable to close instrument
            230 :   Write error
            232 :   Instrument not initialized
            234 :   Error in placing instrument
                    in local mode.    E          Error                              	                     
    K.    init                                       'E     K.    setup                                    (  /      K.    cont_inst                                /  7&     K.    channel                                  8  >     K.    channel_save                             @  N     K.    acquire                                  Q  _     K.    display                                  b  kS     K.    timebase                                 m  t     K.    trigger                                  v_  S 
    K.    wave_read                                  Z     K.    measure                                  	  G     K.    status                                      	    K.    instrument_query                                K.    close                                                                       DInitialize                          JConfigure                            DSave/Recall Setup                    DMODE & AUTOSET                       DInputs                               DChannel Save                         DAcquisition                          DDisplay                              DTime Base                            DTrigger                             Analyse                              DRead Waveform                        DAutomatic Measurements               DIEEE 488.2 Comm/Queries              DInstrument Queries                   DClose                           